/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.RectangleElementsDisplayModel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class DisplayElementInsertHandler {
    protected RectangleElementsDisplayModel fDisplayModel;
    protected DisplayElementLinker[][] fElementLinkers;
    protected String fLastError = null;
    private static String NO_ERROR = "No error";
    private static String OUT_OF_BOUND = "out of bound";

    public DisplayElementInsertHandler(RectangleElementsDisplayModel displayModel) {
        this.fDisplayModel = displayModel;
    }

    protected void syncElementsWithDisplayModel() {
        Dimension d = this.fDisplayModel.getDisplayDimension();
        Point p = new Point();
        if (this.fElementLinkers == null) {
            this.fElementLinkers = new DisplayElementLinker[d.width][d.height];
        }
        for (int x = 0; x < d.width; ++x) {
            for (int y = 0; y < d.height; ++y) {
                if (this.fElementLinkers[x][y] == null) {
                    this.fElementLinkers[x][y] = new DisplayElementLinker();
                }
                p.setLocation(x, y);
                if (!this.fDisplayModel.isEmptyCell(p)) {
                    this.fElementLinkers[x][y].displayElement = this.fDisplayModel.getElementAt(p);
                    Rectangle rect = this.fDisplayModel.getElementBounds(p);
                    this.fElementLinkers[x][y].indexX = x - rect.x;
                    this.fElementLinkers[x][y].indexY = y - rect.y;
                    continue;
                }
                this.fElementLinkers[x][y].displayElement = null;
                this.fElementLinkers[x][y].indexX = 0;
                this.fElementLinkers[x][y].indexY = 0;
            }
        }
        this.fLastError = NO_ERROR;
    }

    protected boolean applyInsertAction() {
        if (!this.isValid()) {
            return false;
        }
        Dimension d = this.fDisplayModel.getDisplayDimension();
        DisplayElement[][] disps = this.fDisplayModel.getDisplayElements();
        for (int x = 0; x < d.width; ++x) {
            for (int y = 0; y < d.height; ++y) {
                disps[x][y] = this.fElementLinkers[x][y] != null && this.fElementLinkers[x][y].displayElement != null && this.fElementLinkers[x][y].indexX == 0 && this.fElementLinkers[x][y].indexY == 0 ? this.fElementLinkers[x][y].displayElement : null;
            }
        }
        return true;
    }

    protected boolean isValid() {
        Dimension d = this.fDisplayModel.getDisplayDimension();
        for (int x = 0; x < d.width; ++x) {
            for (int y = 0; y < d.height; ++y) {
                if (this.fElementLinkers[x][y] == null) continue;
                if (this.fElementLinkers[x][y].indexX > 0) {
                    if (x - 1 < 0) {
                        return false;
                    }
                    if (this.fElementLinkers[x - 1][y] == null || this.fElementLinkers[x - 1][y].displayElement != this.fElementLinkers[x][y].displayElement || this.fElementLinkers[x - 1][y].indexX != this.fElementLinkers[x][y].indexX - 1) {
                        return false;
                    }
                }
                if (this.fElementLinkers[x][y].indexY <= 0) continue;
                if (y - 1 < 0) {
                    return false;
                }
                if (this.fElementLinkers[x][y - 1] != null && this.fElementLinkers[x][y - 1].displayElement == this.fElementLinkers[x][y].displayElement && this.fElementLinkers[x][y - 1].indexY == this.fElementLinkers[x][y].indexY - 1) continue;
                return false;
            }
        }
        return true;
    }

    public boolean insertElements(Point dest, List cells, List elements) {
        this.syncElementsWithDisplayModel();
        if (this.preinsertElements(dest, cells, elements)) {
            return this.applyInsertAction();
        }
        return false;
    }

    public boolean insertElement(Point dest, DisplayElement disp) {
        ArrayList<Point> cells = new ArrayList<Point>();
        cells.add(new Point(0, 0));
        ArrayList<DisplayElement> elements = new ArrayList<DisplayElement>();
        elements.add(disp);
        return this.insertElements(dest, cells, elements);
    }

    private boolean preinsertElements(Point dest, List cells, List elements) {
        AreaInfo areaInfo = new AreaInfo(cells, elements);
        Dimension d = this.fDisplayModel.getDisplayDimension();
        if (dest.y + areaInfo.height > d.height) {
            return false;
        }
        for (int y = dest.y; y < dest.y + areaInfo.height; ++y) {
            int x;
            if (areaInfo.lengths[y - dest.y] > d.width - dest.x) {
                this.fLastError = OUT_OF_BOUND;
                return false;
            }
            for (x = d.width - areaInfo.lengths[y - dest.y]; x < d.width; ++x) {
                if (this.fElementLinkers[x][y] == null || this.fElementLinkers[x][y].displayElement == null) continue;
                this.fLastError = OUT_OF_BOUND;
                return false;
            }
            for (x = d.width - 1; x > dest.x + areaInfo.lengths[y - dest.y] - 1; --x) {
                this.fElementLinkers[x][y] = this.fElementLinkers[x - areaInfo.lengths[y - dest.y]][y];
                this.fElementLinkers[x - areaInfo.lengths[y - dest.y]][y] = null;
            }
        }
        Point p = new Point();
        for (int i = 0; i < cells.size(); ++i) {
            DisplayElement disp = (DisplayElement)elements.get(i);
            int width = disp == null ? 1 : disp.getWidth();
            int height = disp == null ? 1 : disp.getHeight();
            for (int x = 0; x < width; ++x) {
                int y = 0;
                while (y < height) {
                    p.x = dest.x + ((Point)cells.get((int)i)).x - areaInfo.upperLeftCorner.x + x;
                    p.y = dest.y + ((Point)cells.get((int)i)).y - areaInfo.upperLeftCorner.y + y;
                    if (this.fElementLinkers[p.x][p.y] == null) {
                        this.fElementLinkers[p.x][p.y] = new DisplayElementLinker();
                    }
                    this.fElementLinkers[p.x][p.y].displayElement = disp;
                    this.fElementLinkers[p.x][p.y].indexX = x;
                    this.fElementLinkers[p.x][p.y].indexY = y++;
                }
            }
        }
        return true;
    }

    public boolean deleteElement(Point location) {
        ArrayList<Point> cells = new ArrayList<Point>();
        cells.add(location);
        return this.deleteElements(cells);
    }

    public boolean deleteElements(List cells) {
        this.syncElementsWithDisplayModel();
        if (this.predeleteElements(cells)) {
            return this.applyInsertAction();
        }
        return false;
    }

    private boolean predeleteElements(List cells) {
        List elements = this.fDisplayModel.getCellsElements(cells);
        AreaInfo areaInfo = new AreaInfo(cells, elements);
        Point p = new Point();
        Rectangle rect = new Rectangle(new Point(0, 0), this.fDisplayModel.getDisplayDimension());
        for (int y = 0; y < areaInfo.height; ++y) {
            for (int x = 0; x < areaInfo.lengths[y]; ++x) {
                p.x = x + areaInfo.upperLeftCorner.x;
                p.y = y + areaInfo.upperLeftCorner.y;
                if (!rect.contains(p)) {
                    return false;
                }
                this.fElementLinkers[p.x][p.y].displayElement = null;
            }
        }
        Point dest = areaInfo.upperLeftCorner;
        for (int y = dest.y; y < dest.y + areaInfo.height; ++y) {
            int x = dest.x;
            while ((double)x < this.fDisplayModel.getDisplayDimension().getWidth() - (double)areaInfo.lengths[y - dest.y]) {
                this.fElementLinkers[x][y] = this.fElementLinkers[x + areaInfo.lengths[y - dest.y]][y];
                this.fElementLinkers[x + areaInfo.lengths[y - dest.y]][y] = null;
                ++x;
            }
        }
        return true;
    }

    public boolean moveElements(Point destination, List cells) {
        this.syncElementsWithDisplayModel();
        if (this.predeleteElements(cells) && this.preinsertElements(destination, cells, this.fDisplayModel.getCellsElements(cells))) {
            return this.applyInsertAction();
        }
        return false;
    }

    public boolean replaceBarElement(Point focus, Point destination, DisplayElement newElement) {
        this.syncElementsWithDisplayModel();
        ArrayList<Point> cellsOld = new ArrayList<Point>();
        cellsOld.add(focus);
        ArrayList<Point> cellsNew = new ArrayList<Point>();
        cellsNew.add(destination);
        ArrayList<DisplayElement> elements = new ArrayList<DisplayElement>();
        elements.add(newElement);
        if (this.predeleteElements(cellsOld) && this.preinsertElements(destination, cellsNew, elements)) {
            return this.applyInsertAction();
        }
        return false;
    }

    public String getLastErrorString() {
        return this.fLastError;
    }

    private static Point getUpperLeftCorner(List cells) {
        Point upperLeftCorner = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        for (int i = 0; i < cells.size(); ++i) {
            Point cell = (Point)cells.get(i);
            if (cell.x < upperLeftCorner.x) {
                upperLeftCorner.x = cell.x;
            }
            if (cell.y >= upperLeftCorner.y) continue;
            upperLeftCorner.y = cell.y;
        }
        return upperLeftCorner;
    }

    public static class AreaInfo {
        public Point upperLeftCorner;
        public int height;
        public int[] lengths;

        public AreaInfo(List cells, List elements) {
            DisplayElement disp;
            Point cell;
            int i;
            this.upperLeftCorner = DisplayElementInsertHandler.getUpperLeftCorner(cells);
            int bottom = Integer.MIN_VALUE;
            for (i = 0; i < cells.size(); ++i) {
                int height;
                cell = (Point)cells.get(i);
                disp = (DisplayElement)elements.get(i);
                int n = height = disp == null ? 1 : disp.getHeight();
                if (bottom >= cell.y + height - 1) continue;
                bottom = cell.y + height - 1;
            }
            this.height = bottom - this.upperLeftCorner.y + 1;
            this.lengths = new int[this.height];
            for (i = 0; i < cells.size(); ++i) {
                cell = (Point)cells.get(i);
                disp = (DisplayElement)elements.get(i);
                int width = disp == null ? 1 : disp.getWidth();
                int height = disp == null ? 1 : disp.getHeight();
                for (int y = cell.y; y < cell.y + height; ++y) {
                    if (this.lengths[y - this.upperLeftCorner.y] >= cell.x + width - this.upperLeftCorner.x) continue;
                    this.lengths[y - this.upperLeftCorner.y] = cell.x + width - this.upperLeftCorner.x;
                }
            }
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append("upperLeftCorner: (" + this.upperLeftCorner.x + ", " + this.upperLeftCorner.y + ")\n");
            for (int i = 0; i < this.lengths.length; ++i) {
                ret.append("Length" + (i + 1) + ": " + this.lengths[i]);
            }
            return ret.toString();
        }

        public boolean contains(Rectangle elementBounds) {
            for (int x = elementBounds.x; x < elementBounds.x + elementBounds.width; ++x) {
                for (int y = elementBounds.y; y < elementBounds.y + elementBounds.height; ++y) {
                    if (this.contains(new Point(x, y))) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean contains(Point p) {
            for (int y = 0; y < this.height; ++y) {
                if (!new Rectangle(this.upperLeftCorner.x, this.upperLeftCorner.y + y, this.lengths[y], 1).contains(p)) continue;
                return true;
            }
            return false;
        }
    }

    private static class DisplayElementLinker {
        public int indexX;
        public int indexY;
        public DisplayElement displayElement;

        private DisplayElementLinker() {
        }
    }
}

